<?php
use app\models\Game;
use app\models\Event;
use yii\helpers\Url;

/** @var yii\web\View $this */
/** @var Game[] $popularGames */
/** @var Event[] $upcomingEvents */

$this->title = 'Настольные игры для любой компании';
?>

<!-- Hero — главный баннер -->
<section class="hero">
    <div class="container" style="text-align: center; padding: 100px 20px;">
        <div class="logo" style="font-size: 42px; font-weight: 800; color: #5d7a5b; margin-bottom: 16px;">НАСТОЛКА</div>
        <h1 style="font-size: 40px; color: #333; margin-bottom: 20px; font-weight: 700;">
            Настольные игры для любой компании
        </h1>
        <p style="font-size: 18px; color: #666; max-width: 600px; margin: 0 auto 30px;">
            Собирайтесь, играйте, общайтесь — без экранов, только живые эмоции.
        </p>
        <a href="<?= Url::to(['/application/create']) ?>"
           style="display: inline-block; background: #5d7a5b; color: white; padding: 14px 32px; border-radius: 12px; font-weight: 600; text-decoration: none; transition: background 0.2s;"
           onmouseover="this.style.background='#4a6146'"
           onmouseout="this.style.background='#5d7a5b'">
            Записаться на игру
        </a>
    </div>
</section>

<!-- О нас -->
<section id="about" class="section" style="background: #ffffff;">
    <div class="container">
        <h2>О нас</h2>
        <p style="text-align: center; max-width: 700px; margin: 0 auto; color: #555; font-size: 17px;">
            «Настолка» — это сообщество, где новички и профи находят компанию для игр.
            Мы создаём уютную атмосферу, продумываем каждую деталь и гарантируем честные правила.
        </p>
    </div>
</section>

<!-- Каталог игр -->
<section id="games" class="section" style="background: #faf9f6;">
    <div class="container">
        <h2>Каталог игр</h2>
        <div class="game-categories" style="justify-content: center; margin-top: 20px;">
            <div class="category">Классические</div>
            <div class="category">Карточные</div>
            <div class="category">Экономические</div>
            <div class="category">Стратегии</div>
            <div class="category">Для детей</div>
        </div>
        <div style="text-align: center; margin-top: 24px;">
            <a href="<?= Url::to(['/site/games']) ?>"
               style="color: #5d7a5b; text-decoration: underline; font-weight: 500;">
                Посмотреть весь каталог →
            </a>
        </div>
    </div>
</section>

<!-- Слайдер популярных игр -->
<section class="section" style="background: #ffffff;">
    <div class="container">
        <h2 style="margin-bottom: 30px;">Популярные игры</h2>
        <div class="slider" style="padding: 10px 0;">
            <?php foreach (array_slice($popularGames, 0, 6) as $game): ?>
                <div class="slide" style="min-width: 180px;">
                    <div class="game-card" style="height: 100%; padding: 20px; text-align: center;">
                        <h3><?= htmlspecialchars($game->name) ?></h3>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- График игр -->
<section id="events" class="section" style="background: #faf9f6;">
    <div class="container">
        <h2>Игры на ближайший месяц</h2>
        <?php if ($upcomingEvents): ?>
            <div class="events-list">
                <?php foreach (array_slice($upcomingEvents, 0, 4) as $event): ?>
                    <div class="event-item" style="align-items: center;">
                        <div class="event-date" style="min-width: 80px; text-align: center;">
                            <?= Yii::$app->formatter->asDate($event->date, 'php:j M') ?>
                        </div>
                        <div class="event-info" style="flex: 1;">
                            <div class="event-game" style="font-weight: 600;"><?= htmlspecialchars($event->game->name) ?></div>
                            <div style="color: #666; font-size: 15px;">
                                <?= $event->start_time ?> · <?= htmlspecialchars($event->address) ?>
                            </div>
                        </div>
                        <div style="font-weight: 700; color: #5d7a5b;">
                            <?= number_format($event->price, 0, '', ' ') ?> ₽
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            <div style="text-align: center; margin-top: 24px;">
                <a href="<?= Url::to(['/application/create']) ?>" class="btn-submit"
                   style="display: inline-block; width: auto; padding: 10px 24px; font-size: 16px;">
                    Записаться на игру
                </a>
            </div>
        <?php else: ?>
            <p style="text-align: center; color: #888;">Пока нет запланированных игр.</p>
        <?php endif; ?>
    </div>
</section>

<!-- Подписка -->


<!-- Отзывы -->
<section class="section" style="background: #faf9f6;">
    <div class="container">
        <h2 style="margin-bottom: 30px;">Отзывы участников</h2>
        <div style="max-width: 800px; margin: 0 auto; display: grid; gap: 20px;">
            <div class="reviews">
                <div class="review" style="text-align: left; padding: 24px; background: white; border-radius: 16px; box-shadow: 0 4px 12px rgba(0,0,0,0.06);">
                    <p>«Отличная атмосфера! Впервые сыграл в „Бункер“ — теперь фанат!»</p>
                    <div class="review-author" style="text-align: right; margin-top: 12px; color: #8c6d5e; font-weight: 600;">
                        — Алексей, 28 лет
                    </div>
                </div>
                <div class="review" style="text-align: left; padding: 24px; background: white; border-radius: 16px; box-shadow: 0 4px 12px rgba(0,0,0,0.06);">
                    <p>«Организовано всё чётко, всё по времени. Спасибо за вечер!»</p>
                    <div class="review-author" style="text-align: right; margin-top: 12px; color: #8c6d5e; font-weight: 600;">
                        — Марина, 32 года
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Контакты -->
