<?php
use app\models\Game;
use app\models\GameCategory;
use yii\helpers\Url;

/** @var yii\web\View $this */
/** @var Game[] $games */

$this->title = 'Каталог настольных игр';
?>
<div class="container">
    <h1 class="mb-4">Каталог настольных игр</h1>

    <?php
    // Группируем игры по категориям
    $grouped = [];
    foreach ($games as $game) {
        if ($game->category) {
            $grouped[$game->category->id]['category'] = $game->category;
            $grouped[$game->category->id]['games'][] = $game;
        }
    }
    ?>

    <?php if (empty($games)): ?>
        <div class="alert alert-info">
            В каталоге пока нет игр
        </div>
    <?php else: ?>
        <?php foreach ($grouped as $categoryId => $categoryData): ?>
            <div class="mb-5">
                <h2 class="mb-3"><?= htmlspecialchars($categoryData['category']->name) ?></h2>

                <div class="row">
                    <?php foreach ($categoryData['games'] as $game): ?>
                        <div class="col-md-4 mb-3">
                            <div class="card h-100">
                                <div class="card-body">
                                    <h5 class="card-title"><?= htmlspecialchars($game->name) ?></h5>

                                    <!-- Убрано поле description -->

                                    <!-- Эти поля тоже могут отсутствовать, проверяем их наличие -->
                                    <?php if (isset($game->min_players) || isset($game->max_players)): ?>
                                        <p class="mb-1">
                                            Игроков:
                                            <?php if (isset($game->min_players)): ?>
                                                <?= $game->min_players ?>
                                            <?php endif; ?>
                                            <?php if (isset($game->min_players) && isset($game->max_players)): ?>-<?php endif; ?>
                                            <?php if (isset($game->max_players)): ?>
                                                <?= $game->max_players ?>
                                            <?php endif; ?>
                                        </p>
                                    <?php endif; ?>

                                    <?php if (isset($game->duration)): ?>
                                        <p class="mb-1">Время игры: <?= $game->duration ?> мин.</p>
                                    <?php endif; ?>
                                </div>
                                <div class="card-footer bg-white">
                                    <a href="<?= Url::to(['/application/create']) ?>" class="btn btn-primary btn-sm">
                                        Записаться
                                    </a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>
</div>