<?php
use yii\helpers\Html;
use yii\helpers\Url;

/** @var yii\web\View $this */
/** @var string $content */

$isGuest = Yii::$app->user->isGuest;
$isAdmin = !$isGuest && Yii::$app->user->identity->role === 'admin';
?>
<?php $this->beginPage() ?>
    <!DOCTYPE html>
    <html lang="<?= Yii::$app->language ?>">
    <head>
        <meta charset="<?= Yii::$app->charset ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <?= Html::csrfMetaTags() ?>
        <title><?= Html::encode($this->title ?? 'Настолка') ?></title>

        <!-- Bootstrap 5 CSS -->
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

        <!-- Простой CSS -->
        <link rel="stylesheet" href="<?= Yii::getAlias('@web/css/site.css') ?>">

        <?php $this->head() ?>
    </head>
    <body>
    <?php $this->beginBody() ?>

    <!-- Простая шапка -->
    <header class="header">
        <div class="container">
            <nav class="navbar navbar-expand-lg">
                <div class="container-fluid">
                    <a class="navbar-brand" href="<?= Url::to(['/site/index']) ?>">НАСТОЛКА</a>

                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbar">
                        <span class="navbar-toggler-icon"></span>
                    </button>

                    <div class="collapse navbar-collapse" id="navbar">
                        <ul class="navbar-nav me-auto">
                            <li class="nav-item">
                                <a class="nav-link" href="<?= Url::to(['/site/index']) ?>">Главная</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="<?= Url::to(['/site/games']) ?>">Каталог игр</a>
                            </li>
                            <?php if (!$isGuest): ?>
                                <li class="nav-item">
                                    <a class="nav-link" href="<?= Url::to(['/application/create']) ?>">Записаться</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="<?= Url::to(['/application/index']) ?>">Мои заявки</a>
                                </li>
                            <?php endif; ?>
                            <?php if (!Yii::$app->user->isGuest && Yii::$app->user->identity->role === 'admin'): ?>
                                <li class="nav-item">
                                    <a class="nav-link" href="<?= Url::to(['/admin/index']) ?>">
                                        Админка
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>

                        <ul class="navbar-nav">
                            <?php if ($isGuest): ?>
                                <li class="nav-item">
                                    <a class="nav-link" href="<?= Url::to(['/auth/signup']) ?>">Регистрация</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="<?= Url::to(['/auth/login']) ?>">Войти</a>
                                </li>
                            <?php else: ?>

                                <li class="nav-item">
                                    <a class="nav-link" href="<?= Url::to(['/auth/logout']) ?>" data-method="post">Выйти</a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
            </nav>
        </div>
    </header>

    <!-- Основной контент -->
    <main class="main-content">
        <div class="container mt-4 mb-5">
            <?= $content ?>
        </div>
    </main>

    <!-- Простой подвал -->
    <footer class="footer mt-5">
        <div class="container py-4">
            <div class="row">
                <div class="col-md-6">
                    <h5>Настолка</h5>
                    <p>Клуб настольных игр для любой компании.</p>
                </div>
                <div class="col-md-3">
                    <h5>Меню</h5>
                    <ul class="list-unstyled">
                        <li><a href="<?= Url::to(['/site/index']) ?>">Главная</a></li>
                        <li><a href="<?= Url::to(['/site/games']) ?>">Каталог</a></li>
                        <li><a href="<?= Url::to(['/site/about']) ?>">О нас</a></li>
                    </ul>
                </div>
                <div class="col-md-3">
                    <h5>Контакты</h5>
                    <ul class="list-unstyled">
                        <li>Телефон: +7 (999) 123-45-67</li>
                        <li>Email: info@nastolka.ru</li>
                    </ul>
                </div>
            </div>
            <hr>
            <div class="text-center">
                &copy; <?= date('Y') ?> Настолка
            </div>
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <?php $this->endBody() ?>
    </body>
    </html>
<?php $this->endPage() ?>