<?php
use yii\helpers\Html;

/** @var app\models\Event $model */
/** @var app\models\Game[] $games */
?>

<div class="form-group">
    <label>Игра *</label>
    <select name="Event[game_id]" required>
        <option value="">— Выберите игру —</option>
        <?php foreach ($games as $game): ?>
            <option value="<?= $game->id ?>" <?= $model->game_id == $game->id ? 'selected' : '' ?>>
                <?= htmlspecialchars($game->category->name . ' → ' . $game->name) ?>
            </option>
        <?php endforeach; ?>
    </select>
</div>

<div class="form-group">
    <label>Дата *</label>
    <input type="date" name="Event[date]" value="<?= $model->date ?>" required>
</div>

<div class="form-group">
    <label>Время начала *</label>
    <input type="time" name="Event[start_time]" value="<?= $model->start_time ?>" required>
</div>

<div class="form-group">
    <label>Адрес *</label>
    <input type="text" name="Event[address]" value="<?= htmlspecialchars($model->address) ?>" required>
</div>

<div class="form-group">
    <label>Стоимость (₽) *</label>
    <input type="number" name="Event[price]" value="<?= $model->price ?>" min="0" step="10" required>
</div>