<?php

use yii\helpers\Html;
use yii\helpers\Url;

/** @var yii\web\View $this */

$this->title = 'Вход';
?>
<div class="container">
    <div class="auth-card">
        <h1>Вход</h1>

        <?php if (Yii::$app->session->hasFlash('error')): ?>
            <div class="alert alert-danger">
                <?= Yii::$app->session->getFlash('error') ?>
            </div>
        <?php endif; ?>

        <form method="post">
            <?= Html::hiddenInput(Yii::$app->request->csrfParam, Yii::$app->request->csrfToken) ?>

            <div class="mb-3">
                <label for="phone" class="form-label">Телефон</label>
                <input type="tel"
                       id="phone"
                       name="phone"
                       class="form-control"
                       placeholder="8 999 999-99-99"
                       required>
            </div>

            <div class="mb-3">
                <label for="password" class="form-label">Пароль</label>
                <input type="password"
                       id="password"
                       name="password"
                       class="form-control"
                       required>
            </div>

            <button type="submit" class="btn btn-primary w-100 mb-3">Войти</button>

            <div class="text-center">
                <a href="<?= Url::to(['/auth/signup']) ?>">Нет аккаунта? Зарегистрироваться</a>
            </div>
        </form>
    </div>
</div>