<?php

namespace app\models;

use yii\db\ActiveRecord;

/**
 * @property int $id
 * @property int $category_id
 * @property string $name
 * @property string|null $description
 * @property int|null $min_players
 * @property int|null $max_players
 * @property int|null $duration
 * @property int|null $age_rating
 * @property string|null $rules_url
 */
class Game extends ActiveRecord
{
    public static function tableName()
    {
        return 'game';
    }

    public function rules()
    {
        return [
            [['name', 'category_id'], 'required'],
            [['category_id', 'min_players', 'max_players', 'duration', 'age_rating'], 'integer'],
            [['name', 'rules_url'], 'string', 'max' => 255],
            [['description'], 'string'],
        ];
    }

    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Название',
            'category_id' => 'Категория',
            'description' => 'Описание',
            'min_players' => 'Минимум игроков',
            'max_players' => 'Максимум игроков',
            'duration' => 'Продолжительность (мин)',
            'age_rating' => 'Возрастное ограничение',
            'rules_url' => 'Ссылка на правила',
        ];
    }

    public function getCategory()
    {
        return $this->hasOne(GameCategory::class, ['id' => 'category_id']);
    }

    public function getEvents()
    {
        return $this->hasMany(Event::class, ['game_id' => 'id']);
    }
}