<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use app\models\User;

class AuthController extends Controller
{
    public function actionSignup()
    {
        $model = new User();

        if ($model->load(Yii::$app->request->post())) {
            $rules = Yii::$app->request->post('rules');
            if (!$rules) {
                Yii::$app->session->setFlash('error', 'Вы должны согласиться с правилами регистрации');
                return $this->render('signup', ['model' => $model]);
            }

            if ($model->save()) {
                Yii::$app->session->setFlash('success', 'Регистрация прошла успешно!');
                return $this->redirect(['login']);
            }
        }

        return $this->render('signup', ['model' => $model]);
    }

    public function actionLogin()
    {
        if (!Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $phone = Yii::$app->request->post('phone');
        $password = Yii::$app->request->post('password');

        if ($phone && $password) {
            // Проверка на администратора из ТЗ
            if ($phone === '8(999)999-99-99' && $password === 'organizator') {
                // Ищем или создаем администратора
                $admin = User::findOne(['phone' => $phone]);
                if (!$admin) {
                    $admin = new User();
                    $admin->fullname = 'Администратор';
                    $admin->phone = $phone;
                    $admin->email = 'admin@nastolka.ru';
                    $admin->password = $password;
                    $admin->role = 'admin';
                    if (!$admin->save()) {
                        Yii::$app->session->setFlash('error', 'Ошибка создания администратора');
                        return $this->render('login');
                    }
                }

                if ($admin->validatePassword($password)) {
                    Yii::$app->user->login($admin);
                    return $this->goBack();
                }
            }

            // Обычный пользователь
            $user = User::findByPhone($phone);
            if ($user && $user->validatePassword($password)) {
                Yii::$app->user->login($user);
                return $this->goBack();
            } else {
                Yii::$app->session->setFlash('error', 'Неверный телефон или пароль');
            }
        }

        return $this->render('login');
    }

    public function actionLogout()
    {
        Yii::$app->user->logout();
        return $this->goHome();
    }
}