<?php
namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use app\models\Application;
use app\models\Event;

class ApplicationController extends Controller
{
    public function beforeAction($action)
    {
        if (Yii::$app->user->isGuest) {
            Yii::$app->session->setFlash('warning', 'Пожалуйста, войдите в систему.');
            return $this->redirect(['/auth/login']);
        }
        return parent::beforeAction($action);
    }

    public function actionIndex()
    {
        $applications = Application::find()
            ->where(['user_id' => Yii::$app->user->id])
            ->with('event.game')
            ->orderBy('created_at DESC')
            ->all();

        return $this->render('index', ['applications' => $applications]);
    }

    public function actionCreate()
    {
        // Только будущие события
        $events = Event::find()
            ->where(['>=', 'date', date('Y-m-d')])
            ->with('game')
            ->orderBy('date, start_time')
            ->all();

        if (Yii::$app->request->isPost) {
            $eventId = Yii::$app->request->post('event_id');
            $event = Event::findOne($eventId);

            if (!$event) {
                throw new NotFoundHttpException('Событие не найдено.');
            }

            $model = new Application();
            $model->user_id = Yii::$app->user->id;
            $model->event_id = $eventId;
            $model->payment_method = Yii::$app->request->post('payment_method');
            $model->player_level = Yii::$app->request->post('player_level');
            $model->consent = (bool) Yii::$app->request->post('consent');

            if ($model->validate() && $model->save()) {
                Yii::$app->session->setFlash('success', 'Вы успешно записались на игру!');
                return $this->redirect(['index']);
            }
        }

        return $this->render('create', ['events' => $events]);
    }
}